'use strict';

function RequestMetricsController(
  $scope, $api, $user, $location, $window, $focus
) {
  var ctrl = this;
  ctrl.itemsPerPage = 25;
  ctrl.possibleSelections = [25, 50, 75, 100];
  ctrl.pagedItems = [];
  ctrl.currentPage = 0;
  ctrl.requests = {};
  ctrl.havePagedItems = false;
  ctrl.userService = $user;
  ctrl.n = 0;
  $scope.pressed = false;

  ctrl.metricMappings = {
    'Draft': {
      name: 'Draft',
      count: 0
    },
    'Submitted': {
      name: 'Submitted',
      count: 0
    },
    'Returned': {
      name: 'Returned',
      count: 0
    },
    'Denied': {
      name: 'Denied',
      count: 0
    },
    'Sent': {
      name: 'Sent',
      count: 0
    },
    'RequestNotAccepted': {
      name: 'Request Not Accepted',
      count: 0
    },
    'RequestAccepted': {
      name: 'Request Accepted',
      count: 0
    },
    'ResultsDelivered': {
      name: 'Results Delivered',
      count: 0
    },
    'ResultsNotAccepted': {
      name: 'Results Not Accepted',
      count: 0
    },
    'ResultsAccepted': {
      name: 'Results Accepted',
      count: 0
    },
    'Cancelled': {
      name: 'Cancelled',
      count: 0
    }
  };

  ctrl.activeStatus = '';

  if (!$user.allowedToAccess('systemAdministration')) {
    $location.path('/requests');
  }

  ctrl.getActiveStatusClass = function (status) {
    if (status === ctrl.activeStatus) {
      $scope.pressed = true;
      return 'active-status';
    } else {
      $scope.pressed = false;
      return 'nonactive-status';
    }
  };

  $scope.getAriaLabelText = function (n) {
    return 'Page ' + n;
  };

  ctrl.prevPage = function () {
    if (ctrl.currentPage > 0) {
      ctrl.currentPage--;
      $focus('requestsByStatus');
    }
  };

  ctrl.nextPage = function () {
    if (ctrl.currentPage < ctrl.pagedItems.length - 1) {
      ctrl.currentPage++;
      $focus('requestsByStatus');
    }
  };

  ctrl.setPage = function (n) {
    ctrl.currentPage = n;
    $focus('requestsByStatus');
  };

  ctrl.groupToPages = function () {
    ctrl.pagedItems = [];
    for (var i = 0; i < ctrl.requests.length; i++) {
      if (i % ctrl.itemsPerPage === 0) {
        ctrl.pagedItems[Math.floor(i / ctrl.itemsPerPage)] = [ctrl.requests[i]];
      } else {
        ctrl.pagedItems[Math.floor(i / ctrl.itemsPerPage)].push(
          ctrl.requests[i]);
      }
    }
  };
  ctrl.fetchRequestsCounts = function () {
    return $api.retrieve('/requests/status/count', {})
      .then(function (count) {
        if (count.success && count.response) {
          angular.forEach(count.response, function (value) {
            var mapping = ctrl.metricMappings[value.description];
            if (mapping) {
              ctrl.metricMappings[value.description].count = value.count;
            }
          });
        } else {
          $window.alert(count.message);
        }
      });
  };

  ctrl.fetchRequestsByStatus = function (status) {
    return $api.retrieve('requests/' + status + '/status', {})
      .then(function (requestByStatus) {
        ctrl.requests = {};
        if (requestByStatus.success && requestByStatus.response) {
          ctrl.havePagedItems = true;
          ctrl.requests = requestByStatus.response;
          ctrl.currentPage = 0;
          ctrl.activeStatus = status;
          $scope.pressed = true;
          ctrl.groupToPages();
          $focus('mySelect');
        } else {
          $window.alert(requestByStatus.message);
          ctrl.havePagedItems = false;
        }
      });
  };

  ctrl.range = function (length) {
    var range = [];
    for (var i = 0; i < length; i++) {
      range.push(i);
    }

    return range;
  };


  ctrl.onChange = function (possibleSelection) {
    ctrl.itemsPerPage = possibleSelection;
    ctrl.currentPage = 0;
    ctrl.groupToPages();
  };

  ctrl.fetchRequestsCounts();
}

angular.module('genisis').component('requestMetricsDashboard', {
  templateUrl: 'systemAdministration/requestMetrics.html',
  controller: ['$scope', 'api', 'user', '$location', '$window', 'focus',
    RequestMetricsController
  ],
  bindings: {
    itemsPerPage: '<',
    possibleSelections: '<',
    pagedItems: '<',
    currentPage: '<',
    metricMappings: '<',
    requests: '<',
    havePagedItems: '@',
  }
});
// ctrl.itemsPerPage = 25;
// ctrl.possibleSelections = [25, 50, 75, 100];
// ctrl.pagedItems = [];
// ctrl.currentPage = 0;
// ctrl.count = {};
// ctrl.havePagedItems = false;
// ctrl.userService = $user;
// ctrl.n = 0;